Imports MelissaData

Module Module1

    Dim the_license As String = "license here"
    Dim datafile_dir As String = "C:\\Program Files\\Melissa Data\\COM Objects\\Data Files"

    Sub Main()
        Dim addrObj As mdAddr = New mdAddr
        addrObj.SetLicenseString(the_license)
        addrObj.SetPathToUSFiles(datafile_dir)
        'add-ons
        'addrObj.SetPathToDPVDataFiles(datafile_dir);
        'addrObj.SetPathToLACSLinkDataFiles(datafile_dir);
        'addrObj.SetPathToRBDIFiles(datafile_dir);
        'addrObj.SetPathToCanadaFiles(datafile_dir);
        If (addrObj.InitializeDataFiles <> mdAddr.ProgramStatus.ErrorNone) Then
            Console.WriteLine(("Error initializing mdAddr: " + addrObj.GetInitializeErrorString))
            Console.ReadLine()
            Return
        End If

        'Get information about the object:
        Console.WriteLine(("Build Number: " + addrObj.GetBuildNumber))
        Console.WriteLine(("Database Date: " + addrObj.GetDatabaseDate))
        Console.WriteLine(("Database Expiration Date: " + addrObj.GetExpirationDate))
        Dim proceed As Boolean = True

        While proceed
            'Get Address and Verify
            Console.Write("Enter Address : ")
            Dim address As String = Console.ReadLine
            Console.Write("Enter Address2 : ")
            Dim address2 As String = Console.ReadLine
            Console.Write("Enter City : ")
            Dim city As String = Console.ReadLine
            Console.Write("Enter State : ")
            Dim state As String = Console.ReadLine
            Console.Write("Enter Zip : ")
            Dim zip As String = Console.ReadLine
            addrObj.SetAddress(address)
            addrObj.SetAddress2(address2)
            addrObj.SetCity(city)
            addrObj.SetState(state)
            addrObj.SetZip(zip)
            If addrObj.VerifyAddress Then
                Console.WriteLine(("Status Code: " + addrObj.GetStatusCode))
                Console.WriteLine(("Error Code: " + addrObj.GetErrorCode))
                Console.WriteLine(("Error String: " + addrObj.GetErrorString))
                Console.WriteLine(("Address: " + addrObj.GetAddress))
                Console.WriteLine(("Address2: " + addrObj.GetAddress2))
                Console.WriteLine(("Suite: " + addrObj.GetSuite))
                Console.WriteLine(("Private Mailbox: " + addrObj.GetPrivateMailbox))
                Console.WriteLine(("City: " + addrObj.GetCity))
                Console.WriteLine(("State: " + addrObj.GetState))
                Console.WriteLine(("Zip: " + addrObj.GetZip))
                Console.WriteLine(("Plus4: " + addrObj.GetPlus4))
                Console.WriteLine(("Carrier Route: " + addrObj.GetCarrierRoute))
                Console.WriteLine(("Delivery Point Code: " + addrObj.GetDeliveryPointCode))
                Console.WriteLine(("Delivery Point Check Digit: " + addrObj.GetDeliveryPointCheckDigit))
            Else
                Console.WriteLine(("Status Code: " + addrObj.GetStatusCode))
                Console.WriteLine(("Error Code: " + addrObj.GetErrorCode))
                Console.WriteLine(("Error String: " + addrObj.GetErrorString))
            End If
            Console.Write("Enter X to quit:")
            Dim quit As String = Console.ReadLine
            If (quit.ToUpper.Trim = "X") Then
                proceed = False
            End If

        End While

        addrObj.Dispose()
        Console.ReadLine()
    End Sub

End Module
